/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.calendar.AppointmentProvider;
import de.willuhn.jameica.gui.calendar.AppointmentProviderRegistry;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.plugin.Plugin;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;

public class AppointmentProviderDialog
extends AbstractDialog<List<AppointmentProvider>> {
    private TablePart table = null;
    private List<AppointmentProvider> selected = null;

    public AppointmentProviderDialog(int position) {
        super(position);
        this.setSize(400, 400);
        this.setTitle(this.i18n.tr("Auswahl der anzuzeigenden Kalender"));
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        SimpleContainer c = new SimpleContainer(parent, true);
        c.addText(this.i18n.tr("W\u00e4hlen Sie die anzuzeigenden Kalender aus."), true);
        this.table = new TablePart(null);
        this.table.addColumn(this.i18n.tr("Bezeichnung"), "name");
        this.table.setCheckable(true);
        this.table.setMulti(false);
        this.table.setRememberColWidths(true);
        this.table.removeFeature(FeatureSummary.class);
        this.table.setRememberOrder(false);
        this.table.setFormatter(new TableFormatter(){

            @Override
            public void format(TableItem item) {
                try {
                    AppointmentProvider provider = (AppointmentProvider)item.getData();
                    Plugin plugin = Application.getPluginLoader().findByClass(provider.getClass());
                    Object name = provider.getName();
                    if (plugin != null) {
                        name = plugin.getManifest().getName() + ": " + (String)name;
                    }
                    item.setText((String)name);
                }
                catch (Exception e) {
                    Logger.error((String)"unable to format item", (Throwable)e);
                }
            }
        });
        c.addPart(this.table);
        List<Plugin> plugins = Application.getPluginLoader().getInstalledPlugins();
        for (Plugin plugin : plugins) {
            List<AppointmentProvider> providers = AppointmentProviderRegistry.getAppointmentProviders(plugin);
            Collections.sort(providers, new Comparator<AppointmentProvider>(){

                @Override
                public int compare(AppointmentProvider a1, AppointmentProvider a2) {
                    return StringUtils.trimToEmpty((String)a1.getName()).compareTo(StringUtils.trimToEmpty((String)a2.getName()));
                }
            });
            for (AppointmentProvider provider : providers) {
                this.table.addItem((Object)provider, AppointmentProviderRegistry.isEnabled(provider));
            }
        }
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(this.i18n.tr("\u00dcbernehmen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                try {
                    AppointmentProviderDialog.this.selected = AppointmentProviderDialog.this.table.getItems(true);
                    List all = AppointmentProviderDialog.this.table.getItems(false);
                    for (AppointmentProvider provider : all) {
                        AppointmentProviderRegistry.setEnabled(provider, AppointmentProviderDialog.this.selected.contains(provider));
                    }
                }
                catch (RemoteException re) {
                    Logger.error((String)"unable to get items", (Throwable)re);
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehlgeschlagen: {0}", re.getMessage()), 1));
                }
                AppointmentProviderDialog.this.close();
            }
        }, null, true, "ok.png");
        buttons.addButton(this.i18n.tr("Abbrechen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, false, "process-stop.png");
        c.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(-1, -1));
    }

    @Override
    protected List<AppointmentProvider> getData() throws Exception {
        if (this.selected == null) {
            throw new OperationCanceledException();
        }
        return this.selected;
    }
}

